#============================================================================== 
# ** Ruby.Numeric
#------------------------------------------------------------------------------
# Description:
# ------------
# Miscellaneous New stuff for the Numeric class.
#  
# Method List:
# ------------
# is_prime?
# linear?
# sign
#==============================================================================

MACL::Loaded << 'Ruby.Numeric'

#============================================================================== 
# ** Numeric     
#==============================================================================

class Numeric
  #-------------------------------------------------------------------------
  #   Name      : Is Prime?
  #   Info      : Checks if a number is prime or not
  #   Author    : Lobosque/Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def is_prime?
    # Not Prime if 0 or one or even
    return false if [0,1].include?(self) or self % 2 == 0
    # Initialize Check Variable
    check = 3
    # While Check is less than self
    while check < Math.sqrt(self)
      # Return false if divisible
      return false if self % check == 0
      # Increase By 2 (Odd numbers only)
      check += 2
    end
    # Is Prime
    return true
  end
  #-------------------------------------------------------------------------
  # * Name      : Linear?
  #   Info      : Tests if Num falls in a + bx
  #   Author    : Trickster
  #   Call Info : Two or Three Arguments Integer A and B
  #               Boolean Neg X allow for negative x
  #-------------------------------------------------------------------------
  def linear?(a, b, negx = true)
    n = self
    return (b == 0 && n == a) || ((n >= a || negx) && (n - a) % b == 0)
  end
  #-------------------------------------------------------------------------
  #   Name      : Sign
  #   Info      : Returns the Sign of the number (0 if 0 1 if + -1 if -)
  #   Author    : Trickster
  #   Call Info : No Arguments
  #-------------------------------------------------------------------------
  def sign
    return zero? ? 0 : (self / self.abs).to_i
  end
end